/*
 * RootItemDisplay.cpp
 *
 *  Created on: 03.11.2009
 *      Author: stefan.detter
 */

#include "RootItem.h"

#include <QFont>
#include <QPixmap>
#include <QBrush>

#include <def.h>
#include <version.h>

TreeItem::TYPE RootItem::itemType() const
{
	return ROOT;
}

QVariant RootItem::data(int column, int role) const
{
	if (role == Qt::DisplayRole){
		switch((TreeItem::COLUMN_INDEX)column)
		{
		case COL_ID:
			return "Reader ID";
		case COL_TagType:
			return "Tag Type";
		case COL_ReadCount:
			return "Read Count";
		case COL_ReadRate:
			return "Read Rate";
		case COL_Action:
			return "Action";
		case COL_State:
			return "State";
		}
	}
	return QVariant();
}


QVariant RootItem::information (int row, int column, int role) const
{
	return TreeItem::information(row, column, role);
}

void RootItem::prepareInformation ( )
{
	int size = 10;

	m_informationHeader.clear();
	m_informationHeader << ROOT_ROW_HEADER;

	m_informationSubHeader.clear();
	m_informationSubHeader << ROOT_ROW_COMMON << ROOT_ROW_READ << ROOT_ROW_APPLICATION;

	m_informationKeys.resize(size);
	m_informationKeys[ROOT_ROW_HEADER]					= APPLICATION_NAME;
	m_informationKeys[ROOT_ROW_COMMON] 					= "Common";
	m_informationKeys[ROOT_ROW_READER_COUNT] 			= "Reader";
	m_informationKeys[ROOT_ROW_READ] 					= "Read";
	m_informationKeys[ROOT_ROW_SHOWN_TAG_COUNT] 		= "Shown - Tags";
	m_informationKeys[ROOT_ROW_SHOWN_UNIQUE_TAG_COUNT] 	= "Shown - Unique Tags";
	m_informationKeys[ROOT_ROW_READ_TAG_COUNT] 			= "Read - Tags";
	m_informationKeys[ROOT_ROW_READ_UNIQUE_TAG_COUNT] 	= "Read - Unique Tags";
	m_informationKeys[ROOT_ROW_APPLICATION] 			= "Application";
	m_informationKeys[ROOT_ROW_APPLICATION_VERSION] 	= "Version";

	m_informationValues.resize(size);
	updateInformation ( );
}

void RootItem::updateInformation ( )
{
	QVector<QString> temp(m_informationValues);

	m_informationValues[ROOT_ROW_READER_COUNT] = 			QString::number(m_readerIndex.size());
	m_informationValues[ROOT_ROW_SHOWN_TAG_COUNT] = 		QString::number(m_shownReaderTags.count());
	m_informationValues[ROOT_ROW_SHOWN_UNIQUE_TAG_COUNT] =	QString::number(m_shownUniqueTags.count());
	m_informationValues[ROOT_ROW_READ_TAG_COUNT] = 			QString::number(m_readReaderTags.count());
	m_informationValues[ROOT_ROW_READ_UNIQUE_TAG_COUNT] =	QString::number(m_readUniqueTags.count());
	m_informationValues[ROOT_ROW_APPLICATION_VERSION] =		g_ReaderSuite_VersionString;

	if(temp != m_informationValues)
		emit informationChanged(ROOT_ROW_READER_COUNT, ROOT_ROW_APPLICATION_VERSION);
}


